////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  ASTaxTableValidator.h
//    Class for reading and validating a tax table.
//
//  Copyright © 2010-2015 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//	06/01/16  E.K.M  Created File
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"
#include "ASObject.h"

namespace ASFoundation
{
	class EXTERNAL_API ASTaxTableValidator : public ASObject
	{
	public:
		enum 
		{
			kEmptyTaxTableErrorId = 1,
			kInvalidTaxTableErrorId
		};

		virtual ~ASTaxTableValidator(void);

		//static ASTaxTableValidator* CreateWithTaxTablePathPublicKey(const CPString& TaxTablePath, const CPString& PublicKey);

		bool IsValidTaxTable(void);

		CPDictionary TaxTableDictionary(void) const;
		ASTaxTableValidator(void);
		ASTaxTableValidator(const CPString& TaxTablePath, const CPString& PublicKey);

	protected:
		//ASTaxTableValidator(void);
		//ASTaxTableValidator(const CPString& TaxTablePath, const CPString& PublicKey);

		CPString PublicKey(void) const;
		void SetPublicKey(const CPString& PublicKey);
		
		void SetLastError(int ErrorId, const CPString& ErrorDescription);

		// Generating dictionary from tax table
		CPDictionary CreateDictionaryForTaxTable(const CPString& TaxTablePath);
		//virtual CPDictionary CreateDictionaryForTaxTable(const CPString& TaxTablePath) = 0;

		bool LoadTaxTableFile(const CPString& TaxTablePath);
		
	private:
		CPString m_PublicKey;
		CPDictionary m_TaxTable;
	};
}

